*! version 5.0
* 13 August 2018
* NIDS
* Master Income do file updated for Nids Wave 5

* THIS IS THE 3rd INCOME DO FILE - PRE-IMPUTATION AGGREGATION DO FILE: 3 OF 7
* This file creates production-level and income variables for section h (agriculture) of the household questionaire

*=====================================================================================================================================
* GLOBALS FOR DATA FILES, DO FILES AND VERSION SUFFIXES

* DEFINED IN "Master Income do file (1 of 7)"

version 12.1

*=====================================================================================================================================

use "$DataIN\HHQuestionnaire_$VersionIN.dta", clear

cap rename hhid w5_hhid
merge 1:1 w5_hhid using "$DataIN\hhderived_$VersionIN.dta", keepusing(w5_dc2011)

*========================================================================================================================================================
*PREPARING THE DATA: SET NON-RESPONSE CODES TO SYSTEM MISSING

cap rename w5_h_* *
foreach var of varlist agcr	agcrml	agcrmlhkg	agcrmlsllyn	agcrmlskg	agcrmlval	agcrsor	agcrsorhkg	agcrsorsllyn	agcrsorskg	agcrsorval	agcrfrt	agcrfrthkg	agcrfrtsllyn	agcrfrtskg	agcrfrtval	agcrpot	agcrpothkg	agcrpotsllyn	agcrpotskg	agcrpotval	agcrpmp	agcrpmphkg	agcrpmpsllyn	agcrpmpskg	agcrpmpval	agcrmad	agcrmadhkg	agcrmadsllyn	agcrmadskg	agcrmadval	agcroni	agcronihkg	agcronisllyn	agcroniskg	agcronival	agcrdb	agcrdbhkg	agcrdbsllyn	agcrdbskg	agcrdbval	agcrgrnveg	agcrgrnveghkg	agcrgrnvegsllyn	agcrgrnvegskg	agcrgrnvegval	agls	aglscat	aglscatown	aglscatsll	aglscatval	aglscatcon	aglsshp	aglsshpown	aglsshpsll	aglsshpval	aglsshpcon	aglsgt	aglsgtown	aglsgtsll	aglsgtval	aglsgtcon	aglspig	aglspigown	aglspigsll	aglspigval	aglspigcon	aglshrs	aglshrsown	aglshrssll	aglshrsval	aglshrscon	aglsdnk	aglsdnkown	aglsdnksll	aglsdnkval	aglsdnkcon	aglschc	aglschcown	aglschcsll	aglschcval	aglschccon	ageggnum	ageggu	agcwmlkmth	agcwmlkamt	aggtmlkmth	aggtmlkamt	agilab	agilabspn	agifrt	agifrtspn	agiman	agimanspn	agichm	agichmspn	agiplgh	agiplghspn	agiseed	agiseedspn	agidip	agidipspn	agivet	agivetspn	agifeed	agifeedspn	agiinv	agiinvspn	agirep	agirepspn {
replace `var' = . if `var' < 0
}

*========================================================================================================================================================
*PART 1 - INCOME FROM CROP PRODUCTION

*CREATING PRICE PER KG FOR EACH CROP

/*The farm gate price is used in cases where no crops were sold by the household. If crops were sold by the household, then the value per kg is calculated*/

**REFERENCES TO PRICES
* W5: DAFF (Department of Agriculture, Fisheries and Forestry) 2018 Abstract of Agricultural Statistics, http://www.daff.gov.za/Daffweb3/Portals/0/Statistics%20and%20Economic%20Analysis/Statistical%20Information/Abstract%202018.pdf
* W4: DAFF (Department of Agriculture, Fisheries and Forestry) 2014 and 2015 prices were obtained from the Abstract of Agricultural Statistics, 2014, 2015 (latest version, obtained directly from DAFF).
* W3: DAFF (Department of Agriculture, Fisheries and Forestry) 2012 prices were obtained from http://www.daff.gov.za/docs/statsinfo/Abstact2013.pdf
* W3: FW Farmers Weekly June 2012 Edition

		**Creating a per kg value for mealies** 
		*W5 price = 1.902 per kg DAFF2018
		*W4 price = 2.122 per kg DAFF2015
		*W4 price = 2.026 per kg DAFF2014
		*W3 price = R2.144 per kg DAFF2013, R2.280 per kg FW 
		*W1 price = R2 (R1.606 DAFF 2008)
		gen  mealiekgprice = 1.902 if agcrml == 1 & agcrmlhkg> 0 &  agcrmlhkg!= .
		replace  mealiekgprice = agcrmlval/ agcrmlskg if agcrmlval>0 & agcrmlval!= . & agcrmlskg> 0 & agcrmlskg!=.


		**Creating a per kg value for Sorghum**
		*W5 price = 2.638 per kg DAFF2018
		*W4 price = 2.812 per kg DAFF2015
		*W4 price = 2.632 per kg DAFF2014
		*W3 price = R2.674 per kg DAFF2013, R3.045 per kg FW
		*W1 price = R2 (R1.744 DAFF 2008)
		gen  sorghumkgprice = 2.638 if agcrsor == 1 &  agcrsorhkg > 0 &  agcrsorhkg!=.
		replace sorghumkgprice = agcrsorval/agcrsorskg if agcrsorval>0 & agcrsorval!=. & agcrsorskg> 0 & agcrsorskg!= .

		
		**Creating a per kg value for fruit** 
		*W5 price = R10.2245 per kg DAFF2018(average price for apples (R6.534), apricots (R14.641), grapes (R13.162), pears (R6.561))
		*W4 price = R7.570 per kg DAFF2015(average price for apples (R5.817), apricots (R8.126), grapes (R10.771), pears (R5.567))
		*W4 price = R6.874 per kg DAFF2014(average price for apples (R5.7), apricots (R6.618), grapes (R9.825), pears (R5.351))
		*W3 price = R6.187 per kg DAFF2013(average price for apples (R5.258), apricots (R6.445), grapes (R8.207), pears (R4.841))    
		*W1 price = R3.5(citrus fruit 1.5(deciduous fruit)) 
		gen  fruitkgprice = 10.2245 if agcrfrt == 1 &  agcrfrthkg > 0 &  agcrfrthkg!=.
		replace fruitkgprice = agcrfrtval/agcrfrtskg if agcrfrtval>0 & agcrfrtval!=. & agcrfrtskg> 0 & agcrfrtskg!= .
		
		
		**Creating a per kg value for potato** 
		*W5 price = R3.6915 Average of ((R3.445 per kg potato,  R3.938 per kg sweet potato (DAFF2018))
		*W4 price = R3.576 Average of ((R3.428 per kg potato,  R3.724 per kg sweet potato (DAFF2015))
		*W4 price = R3.093 Average of ((R3.376 per kg potato,  R2.809 per kg sweet potato (DAFF2014))
		*W3 price = R3.148 Average of ((R2.646 per kg potato, R3.650 per kg sweet potato (DAFF2013)), R3.839 per kg FW
		*W1 price = R3 (R2.20  Average of ((R2.076 potato & R2.325 sweet potato) DAFF 2008)
		gen  potatokgprice = 3.6915 if agcrpot == 1 & agcrpothkg> 0 & agcrpothkg!=.
		replace  potatokgprice = agcrpotval/ agcrpotskg if agcrpotval>0 & agcrpotval!=. & agcrpotskg>0 & agcrpotskg!=.

		
		**Creating a per kg value for pumpkin** 
		*W5 price = R3.023 Average of (R2.540 per kg pumpkin & R3.506 butternut squash) DAFF2018
		*W4 price = R2.6775 Average of (R2.128 per kg pumpkin & R3.227 butternut squash) DAFF2015
		*W4 price = R2.514 Average of (R2.155 per kg pumpkin & R2.873 butternut squash) DAFF2014
		*W3 price = R2.013 Average of (R1.617 per kg pumpkin & R2.409 butternut squash) DAFF2013, 
		*W1 price = R4  (R1.531  Average if (R1.250 pumpkin & R1.813 butternut squash) DAFF 2008 )
		gen  pumpkinkgprice = 3.023  if agcrpmp == 1 & agcrpmphkg > 0 & agcrpmphkg !=.
		replace  pumpkinkgprice = agcrpmpval/ agcrpmpskg  if agcrpmpval >0 & agcrpmpval!=. & agcrpmpskg>0 & agcrpmpskg!=.


		**Creating a per kg value for madumbe** 
		*W5 price = R3.938 We used the price of sweet potatoes from DAFF2018 
		*W4 price = R3.724. We used the price of sweet potatoes from DAFF2015 
		*W4 price = R2.809. We used the price of sweet potatoes from DAFF2014 (note that sweet potato prices have decreased since 2012, which may have not been the case for madumbe) 
		*W3 price = R3.650. We used the price of sweet potatoes from DAFF2013
		*W1 price = R3
		gen  madumbekgprice = 3.938 if agcrmad == 1 & agcrmadhkg > 0 & agcrmadhkg !=.
		replace madumbekgprice = agcrmadval/ agcrmadskg if agcrmadval >0 & agcrmadval!=. & agcrmadskg >0 & agcrmadskg !=.


		**Creating a per kg value for Onions**
		*W5 price = R3.231 per kg DAFF2018
		*W4 price = R3.334 per kg DAFF2015
		*W4 price = R3.433 per kg DAFF2014
		*W3 price = R2.586 per kg DAFF2013, R2.453 per kg Farmers Weekly 25 Oct 2013 
		*W1 price = R4 (R2.167 DAFF 2008)
		gen  onionskgprice =  3.231 if agcroni == 1 & agcronihkg >0 & agcronihkg != .
		replace onionskgprice = agcronival/ agcroniskg if agcronival >0 & agcronival!=. & agcroniskg >0 & agcroniskg !=.


		**Creating a per kg value for legumes** 
		*W5 price = R13.472 Average of (R15.00 Large white kidney beans, R11.388 small white beans, R13.00 sugar beans, R14.5 Haricot beans) DAFF2018
		*W4 price = R13.631 Average of (R20.00 Large white kidney beans, R10.525 small white beans, R11.5 sugar beans, R12.5 Haricot beans) DAFF2015
		*W4 price = R12.3268 Average of (R14.5 Large white kidney beans, R9.63 small white beans, R12.677 sugar beans, R12.5 Haricot beans) DAFF2014
		*W3 price = R11.1135 Average of (R14.00 Large white kidney beans, R8.318.00 Small white beans, R10.636 Sugar beans, R11.50 Haricot beans) DAFF2013, R2.453 per kg FW
		*W1 price = R2
		gen  legumeskgprice = 13.472 if agcrdb == 1 & agcrdbhkg >0 & agcrdbhkg !=.
		replace legumeskgprice = agcrdbval/ agcrdbskg if agcrdbval >0 & agcrdbval !=. & agcrdbskg >0 & agcrdbskg !=.


		**Creating a per kg value for green veg**  
		*W5 price = R2.501 per kg (cabbage) DAFF2018 
		*W4 price = R2.180 per kg (cabbage) DAFF2015 
		*W4 price = R2.074 per kg (cabbage) DAFF2014 
		*W3 price = R1.753 per kg (cabbage) DAFF2013, R2.032 per kg FW
		*W1 price = R2) (R1.080 DAFF 2008)
		gen  greenvegkgprice = 2.501 if agcrgrnveg == 1 & agcrgrnveghkg >0 & agcrgrnveghkg !=.
		replace greenvegkgprice = agcrgrnvegval/ agcrgrnvegskg if agcrgrnvegval >0 & agcrgrnvegval !=. & agcrgrnvegskg >= 0 & agcrgrnvegskg !=.

		
		**Creating a per kg value for tomatoes or peppers**  
		*W5 price = R6.221 per kg (tomatoes) DAFF2018
		*W4 price = R6.082 per kg (tomatoes) DAFF2015
		*W4 price = R4.501 per kg (tomatoes) DAFF2014
		*W1 price 
		gen  tomatokgprice = 6.221 if agcrgrntom == 1 & agcrgrntomhkg >0 & agcrgrntomhkg !=. 
		replace tomatokgprice = agcrgrntomval/ agcrgrntomskg if agcrgrntomval >0 & agcrgrntomval !=. & agcrgrntomskg >= 0 & agcrgrntomskg !=.
		
		**Creating a per kg value for herbs**  
		*W5 price = R2.50
		*W4 price = R2.50
		*W1 price  
		gen  herbkgprice = 2.5 if agcrherb == 1 & agcrherbhkg >0 & agcrherbhkg !=.
		replace herbkgprice = agcrherbval/ agcrherbskg if agcrherbval >0 & agcrherbval !=. & agcrherbskg >= 0 & agcrherbskg !=.
		
*-------------------------------------------------------------------------------------------------------------------

**CREATING AGRICULTURE INCOME AS PRICE PER KG * NUMBER OF KG HARVESTED

	*Mealies Income
	gen mealieinc = agcrmlhkg*mealiekgprice
	replace mealieinc = agcrmlval if agcrmlhkg == . & agcrmlval >0 & agcrmlval!=.  
	//1 hh that does not know how much they harvested, but know how much money they received from selling mealies

	*Sorghum Income	
	gen sorghuminc = agcrsorhkg*sorghumkgprice

	*Fruit Income	
	gen fruitinc = agcrfrthkg*fruitkgprice
	replace fruitinc = agcrfrtval if agcrfrthkg == . & agcrfrtval >0 & agcrfrtval!=.  
	//4 hh that do not know how much they harvested, but know how much money they received from selling fruit

	*Potato Income
	gen potatoinc = agcrpothkg*potatokgprice
	replace potatoinc =  agcrpotval if agcrpothkg == . & agcrpotval >0 & agcrpotval !=. 
	//3 hh that do not know how much they harvested, but know how much money they received from selling potatoes

	*Pumpkin Income
	gen pumpkininc = agcrpmphkg*pumpkinkgprice

	*Madumbe Income 
	gen madumbeinc = agcrmadhkg*madumbekgprice

	*Onion Income
	gen onioninc = agcronihkg*onionskgprice

	*Legume Income
	gen legumeinc = agcrdbhkg*legumeskgprice

	*Green Veg income
	gen greenveginc = agcrgrnveghkg*greenvegkgprice
	replace greenveginc = agcrgrnvegval if agcrgrnveghkg == . & agcrgrnvegval >0 & agcrgrnvegval!=.  
	//2 hh that do not know how much they harvested, but know how much money they received from selling green veg

	*Tomatoes or peppers
	gen tomatoinc = agcrgrntomhkg*tomatokgprice

	*Herbs
	gen herbinc = agcrherbhkg*herbkgprice


drop *price

*-------------------------------------------------------------------------------------------------------------------

*CALCULATING TOTAL INCOME FROM CROP PRODUCTION
egen produceinc = rowtotal(mealieinc sorghuminc fruitinc potatoinc pumpkininc madumbeinc onioninc legumeinc greenveginc tomatoinc herbinc), mi
 
 
 
 
 
 
*========================================================================================================================================================




*PART 2 - INCOME FROM LIVESTOCK  PRODUCE 



*ESTIMATING VALUE OF A SINGLE UNIT OF LIVESTOCK 

	**Creating price per cow value 
	*Use median of sample as price per cow for hh that did not sell any livestock
	*W1 price = R2 800)
	gen cowprice = .
	replace cowprice=aglscatval/aglscatsll
	egen cowprice_median = median(cowprice)  //Median price is R7000
	sum cowprice, d
	replace cowprice= cowprice_median if cowprice==. & (aglscatsll>0 & aglscatsll!=.) 
	replace cowprice= cowprice_median if cowprice==. & (aglscatcon>0 & aglscatcon!=.)
	drop cowprice_median
	
	**Creating price per sheep value 
	*Use median of sample as price per sheep for hh that did not sell any livestock
	*W1 price = R600)
	gen sheepprice=.
	replace sheepprice=aglsshpval/aglsshpsll
	egen sheepprice_median = median(sheepprice) //Median price is R1200
	sum sheepprice, d	
	replace sheepprice=sheepprice_median if sheepprice==. & aglsshpsll>0 & aglsshpsll!=.
	replace sheepprice=sheepprice_median if sheepprice==. & aglsshpcon>0 & aglsshpcon!=.
	*replace sheepprice = sheepprice_median if aglsshpsll>0 & aglsshpsll!=. & aglsshpval == 0	//2 hh's sold 1 800 and 54 000 sheep
	drop sheepprice_median
	
	**Creating price per goat value 
	*Use median of sample as price per goat for hh that did not sell any livestock 
	*W1 price = R500)
	gen goatprice=.
	replace goatprice=aglsgtval/aglsgtsll
	egen goatprice_median = median(goatprice) //Median price is R1125
	sum goatprice, d	
	replace goatprice=goatprice_median if goatprice==. & aglsgtsll>0 & aglsgtsll!=.
	replace goatprice=goatprice_median if goatprice==. & aglsgtcon>0 & aglsgtcon!=.
	drop goatprice_median
	
	**Creating price per pig value 
	*Use median of sample as price per pig for hh that did not sell any livestock
	*W1 price = R)
	gen pigprice=.
	replace pigprice=aglspigval/aglspigsll
	egen pigprice_median = median(pigprice) //Median price is R700
	sum pigprice, d
	replace pigprice=pigprice_median if pigprice==. & aglspigsll>0 & aglspigsll!=.
	replace pigprice=pigprice_median if pigprice==. & aglspigcon>0 & aglspigcon!=.
	*replace pigprice = pigprice_median if aglspigsll>0 & aglspigsll!=. & aglspigval == 0	//1 hh sold 10 000 pigs
	drop pigprice_median
	
	**Creating price per horse value 
	*Use median of sample as price per horse for hh that did not sell any livestock
	*W1 price = R1 000)
	gen horseprice=.
	replace horseprice=aglshrsval/aglshrssll
	egen horseprice_median = median(horseprice) //Median price is R2500
	sum horseprice, d
	replace horseprice=horseprice_median if horseprice==. & aglshrssll>0 & aglshrssll!=.
	replace horseprice=horseprice_median if horseprice==. & aglshrscon>0 & aglshrscon!=.
	drop horseprice_median
	
	**Creating price per donkey value 
	*Use median of sample as price per donkey for hh that did not sell any livestock
	*W1 price = R)
	gen donkeyprice=.
	replace donkeyprice=aglsdnkval/aglsdnksll
	egen donkeyprice_median = median(donkeyprice) //Median price is R300
	sum donkeyprice, d
	replace donkeyprice=donkeyprice_median if donkeyprice==. & aglsdnksll>0 & aglsdnksll!=.
	replace donkeyprice=donkeyprice_median if donkeyprice==. & aglsdnkcon>0 & aglsdnkcon!=.
	drop  donkeyprice_median
	
	**Creating price per chicken value 
	*Use median of sample as price per chicken for hh that did not sell any livestock
	*W1 price = R30)
	gen chickenprice=.
	replace chickenprice=aglschcval/aglschcsll
	egen chickenprice_median = median(chickenprice) //Median price is R60
	sum chickenprice, d
	replace chickenprice=chickenprice_median if chickenprice==. & aglschcsll>0 & aglschcsll!=.
	replace chickenprice=chickenprice_median if chickenprice==. & aglschccon>0 & aglschccon!=.
	*replace chickenprice = chickenprice_median if aglschcsll>0 & aglschcsll!=. & aglschcval == 0 //5 hh's sold 420, 300, 870, 100 and 5 chickens
	drop chickenprice_median
	
*---------------------------------------------------------------------------------------------------

*LIVESTOCK INCOME
	egen num_cattle= rowtotal(aglscatsll aglscatcon), mi
	gen cattleinc = num_cattle*cowprice

	egen num_sheep = rowtotal(aglsshpsll aglsshpcon), mi
	gen sheepinc = num_sheep*sheepprice

	egen num_goat = rowtotal(aglsgtsll aglsgtcon), mi
	gen goatinc = num_goat*goatprice

	egen num_pig =  rowtotal(aglspigsll aglspigcon), mi
	gen piginc	= num_pig*pigprice

	egen num_horse = rowtotal(aglshrssll aglshrscon), mi
	gen horseinc = num_horse*horseprice

	egen num_donkey = rowtotal(aglsdnksll aglsdnkcon), mi
	gen donkeyinc = num_donkey*donkeyprice

	egen num_chicken = rowtotal(aglschcsll aglschccon), mi
	gen  chickeninc= num_chicken*chickenprice

*TOTAL INCOME FROM LIVESTOCK PRODUCE
	egen animalinc =  rowtotal(cattleinc goatinc sheepinc piginc horseinc donkeyinc chickeninc), mi

drop cattleinc sheepinc goatinc piginc horseinc donkeyinc chickeninc num_*



*========================================================================================================================================================




*PART 3 - INCOME FROM LIVESTOCK-RELATED PRODUCE


*INCOME FROM EGGS
	replace ageggu = 1 if ageggu ==. & ageggnum>0 & ageggnum!=. // ****NB: 12 hh with # egg >0 but no units (i.e. ageggu ==-9)
	gen eggunits=.
	replace eggunits = ageggnum*12 if ageggu==1


	replace eggunits = ageggnum if ageggu==2
	replace eggunits=-3 if eggunits==-108
	replace eggunits=-3 if eggunits==-36
	gen eggunitannual=.
	replace eggunitannual=eggunits*12
	replace eggunitannual=-3 if eggunitannual==-36
	replace eggunitannual=-3 if eggunitannual==-108
	
	*W5 price = R0.99825 per egg DAFF2017	//1197.9/(12*100)
	*W4 price = R0.8934 per egg DAFF2015   //1072.1/(12*100)
	*W4 price = R0.8288 per egg DAFF2014
	*W3 price = R0.7701 per egg DAFF2013 
	*W1 price = R0.50 (R0.6249 DAFF 2008)
	gen egginc=.
	replace egginc=eggunitannual* 0.99825

	

*INCOME FROM MILK OR SOUR MILK FROM COW
	
	gen cowmilklitre=.
	replace cowmilklitre = agcwmlkmth * agcwmlkamt
	replace cowmilklitre = 0 if agcwmlkamt < 0
	replace cowmilklitre = agcwmlkamt if agcwmlkamt> 0 & agcwmlkamt!= . & agcwmlkmth <0
	
	*W5 price = R4.128 per litre DAFF2017	//412.8/100
	*W4 price = R3.820 per litre DAFF2015	//382.0/100
	*W4 price = R3.485 per litre DAFF2014
	*W3 price = R2.992 per litre DAFF2013
	*W1 price = R1.50 (R2.733 DAFF 2008)
	gen cowmilkinc=.
	replace cowmilkinc=cowmilklitre* 4.128
	
*INCOME FROM MILK OR SOUR MILK FROM SHEEP
	
	gen shpmilklitre=.
	replace shpmilklitre = agshpmlkmth * agshpmlkamt
	replace shpmilklitre = 0 if agshpmlkamt < 0
	replace shpmilklitre = agshpmlkamt if agshpmlkamt> 0 & agshpmlkamt!= . & agshpmlkamt <0
	
	
	//Assume that price for sheep milk is the same as price for cow milk since there was no other reference	
	gen shpmilkinc=.
	replace shpmilkinc=shpmilklitre* 4.128


*INCOME FROM MILK OR SOUR MILK FROM GOAT

	gen goatmilklitre=.
	replace goatmilklitre = aggtmlkmth * aggtmlkamt
	replace goatmilklitre = 0 if aggtmlkamt < 0
	replace goatmilklitre = aggtmlkamt if aggtmlkamt> 0 & aggtmlkamt!= . & aggtmlkmth <0
	

	//Assume that price for goat milk is the same as price for cow milk since there was no other reference
	gen goatmilkinc=.
	replace goatmilkinc=goatmilklitre* 4.128   


*TOTAL INCOME FROM LIVESTOCK-RELATED PRODUCE
egen animalbyprodinc =  rowtotal(egginc cowmilkinc goatmilkinc shpmilkinc), mi

drop eggunits eggunitannual cowmilklitre goatmilklitre
*========================================================================================================================================================

*PART 4 - CALCULATING COST OF INPUTS

*THINGS YOU HAD TO DO TO PRODUCE CROPS

	gen buylabour=.
	replace buylabour=agilabspn
	replace buylabour=0 if buylabour==.
	replace buylabour=0 if buylabour<0

	gen buyfertil=.
	replace buyfertil=agifrtspn
	replace buyfertil=0 if buyfertil==.
	replace buyfertil=0 if buyfertil<0

	gen buymanure=.
	replace buymanure=agimanspn
	replace buymanure=0 if buymanure==.
	replace buymanure=0 if buymanure<0

	gen buychem=.
	replace buychem=agichmspn
	replace buychem=0 if buychem==.
	replace buychem=0 if buychem<0

	gen buyplough=.
	replace buyplough=agiplghspn
	replace buyplough=0 if buyplough==.
	replace buyplough=0 if buyplough<0

	gen buyseeds=.
	replace buyseeds=agiseedspn
	replace buyseeds=0 if buyseeds==.
	replace buyseeds=0 if buyseeds<0

	gen buydip=.
	replace buydip=agidipspn
	replace buydip=0 if buydip==.
	replace buydip=0 if buydip<0

	gen buyvet=.
	replace buyvet=agivetspn
	replace buyvet=0 if buyvet==.
	replace buyvet=0 if buyvet<0

	gen buyfeed=.
	replace buyfeed=agifeedspn
	replace buyfeed=0 if buyfeed==.
	replace buyfeed=0 if buyfeed<0

	gen buyinvest=.
	replace buyinvest=agiinvspn
	replace buyinvest=0 if buyinvest==.
	replace buyinvest=0 if buyinvest<0

	gen buyrepair=.
	replace buyrepair=agirepspn
	replace buyrepair=0 if buyrepair==.
	replace buyrepair=0 if buyrepair<0
	
	gen buywater=.
	replace buywater=agiwatspn
	replace buywater=0 if buywater==.
	replace buywater=0 if buywater<0

egen inputcosts= rowtotal(buylabour buyfertil buymanure buychem buyplough buyseeds buydip buyvet buyfeed buyinvest buyrepair buywater), mi


*=====================================================================================================================================================

*PART 5 - Aggregation of all income variables
egen agric_inc = rowtotal (producein  animalinc  animalbyprodinc), mi
gen netagriincome= agric_inc  - inputcosts
replace netagriincome=. if ag==2

keep w5_hhid netagriincome 
rename netagriincome hhagric
replace hhagric=0 if hhagric<0
replace hhagric=hhagric/12
label variable hhagric "Household average monthly income from subsistence agriculture"


sort w5_hhid

save "$DataOUT\hhagric.dta", replace

*=====================================================================================================================================
